unit Unit1;

//  
//      
//  TStringGrid,    
//      
// onClick   .

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, StdCtrls, Buttons, ExtCtrls;

type
  TForm1 = class(TForm)
    StringGrid1: TStringGrid;
    BitBtnAdd: TBitBtn;
    BitBtnDel: TBitBtn;
    BitBtnErase: TBitBtn;
    STextCol: TStaticText;
    STextRow: TStaticText;
    LabelCol: TLabel;
    LabelRow: TLabel;
    BevelCellIndex: TBevel;
    LabelTitle: TLabel;
    LabelCellIndex: TLabel;
    procedure BitBtnAddClick(Sender: TObject);
    procedure BitBtnDelClick(Sender: TObject);
    procedure BitBtnEraseClick(Sender: TObject);
    procedure StringGrid1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
{$R *.dfm}

var SelectRowInd : integer;   //    
    SelectColInd : integer;   //    

//       
procedure InitStringGrid(SGrid : TStringGrid);
var Row, Col : integer;
begin
  //    
  SGrid.RowCount := 5;  //   
  SGrid.ColCount := 5;  //   
  //        
  SGrid.FixedRows := 1;
  SGrid.FixedCols := 1;
  //   
  SGrid.Options := SGrid.Options    //    
                + [goColSizing]     //    
                + [goEditing]       //    
                - [goRangeSelect];  //    
 //      
 if SGrid.FixedRows > 0
 then begin
   for Row := SGrid.FixedRows to (SGrid.RowCount -1)
   do  SGrid.Cells[0,Row]:= IntToStr(Row);
 end;
 //       
 if SGrid.FixedCols > 0
 then begin
   for Col := SGrid.FixedCols to (SGrid.ColCount -1)
   do  SGrid.Cells[Col,0]:= IntToStr(Col);
 end;
end;

//       
procedure TForm1.FormCreate(Sender: TObject);
begin
   SelectColInd:= 0;
   SelectRowInd:= 0;
   InitStringGrid(StringGrid1);
end;

//    
procedure TForm1.BitBtnAddClick(Sender: TObject);
var Row : integer;
begin
  //   
  Row := StringGrid1.RowCount;
  //          
  StringGrid1.RowCount := StringGrid1.RowCount + 1;
  //      
 if StringGrid1.FixedRows > 0
 then begin
   StringGrid1.Cells[0,Row]:= IntToStr(Row);
 end;
end;

//    
procedure TForm1.BitBtnDelClick(Sender: TObject);
begin
  if (StringGrid1.RowCount - 1) > StringGrid1.FixedRows
  then StringGrid1.RowCount := StringGrid1.RowCount-1;
end;

//    
procedure TForm1.BitBtnEraseClick(Sender: TObject);
begin
  if SelectRowInd > 0 then begin
     StringGrid1.Rows[SelectRowInd].Clear;
  end;
end;

//      
procedure TForm1.StringGrid1Click(Sender: TObject);
begin
   SelectColInd := StringGrid1.Col;
   STextCol.Caption := IntToStr(SelectColInd);
   SelectRowInd := StringGrid1.Row;
   STextRow.Caption := IntToStr(SelectRowInd);
end;

end.
